



<html>
<head>
  <title>javabog.dk -  - RMI - objekter over netv&aelig;rk</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel18.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel20.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">19 <a name='afsn19'></a>RMI -
objekter over netv&aelig;rk</H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">Forst&aring; principperne i
  RMI</P>
  <LI><P CLASS="kapiteloversigt-western">Kalde metoder i fjerne
  objekter</P>
</UL>
<P CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes ikke i
resten af bogen.</P>
<P CLASS="kapiteloversigt-western">Foruds&aelig;tter <a href='kapitel12.jsp'>kapitel 12</a>, Interfaces,
<a href='kapitel18.jsp'>kapitel 18</a>, Serialisering og kendskab til netv&aelig;rk.</P>


<P CLASS="western" STYLE="">Med RMI (Remote
Method Invocation) kan man arbejde med objekter, der eksisterer i en
anden Java virtuel maskine (ofte p&aring; en anden fysisk maskine),
<I>som om de var lokale objekter</I>.</P>
<H2 CLASS="western">19.1 <a name='afsn19.1'></a>Principper</SPAN></H2>
<P CLASS="western">Herunder er tegnet, hvad der sker, n&aring;r en
klient p&aring; maskine A laver et kald til et serverobjekt
(v&aelig;rts-objekt), der er i maskine B.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog20_html_m8fac41c.gif" NAME="Objekt1" ALIGN=MIDDLE></P>
<P CLASS="western">Serverobjektet findes slet ikke p&aring; maskine
A, i stedet er der en s&aring;kaldt <I>RMI-stub</I>, der
repr&aelig;senterer det. N&aring;r der sker et kald til
RMI-stubben p&aring; maskine A, s&oslash;rger den for at transportere
kaldet og alle parametre til maskine B, hvor serverobjektet bliver
kaldt, som om det var et lokalt kald. Serverobjektets svar bliver
transporteret tilbage til RMI-stubben, der returnerer det til
klienten.</P>
<P CLASS="western">Denne proces foreg&aring;r helt automatisk og er
usynlig for klienten s&aring;vel som serverobjektet. 
</P>
<P CLASS="western">RMI benytter serialisering til at transportere
parametre og returv&aelig;rdi mellem maskinerne, s&aring; man skal
huske, at alle objekter, der sendes over netv&aelig;rket, skal
implementere Serializable-interfacet og at variabler, der ikke
skal overf&oslash;res, skal m&aelig;rkes med n&oslash;gleordet
transient.</P>
<P CLASS="western">Der skal v&aelig;re defineret et interface (kaldet
fjerninterfacet) til de metoder p&aring; serverobjektet, som skal
v&aelig;re tilg&aelig;ngelige for klienten. Serverobjekt skal
implementere dette interface.</P>
<H2 CLASS="western">19.2 <a name='afsn19.2'></a>I praksis</SPAN></H2>
<P CLASS="western">Lad os forestille os, at serveren har et
konto-objekt, hvor man kan overf&oslash;re penge, sp&oslash;rge om
saldo og f&aring; bev&aelig;gelserne. Disse metoder skal v&aelig;re
tilg&aelig;ngelige over netv&aelig;rket, s&aring; vi definerer et
fjerninterface til kontoen (her kaldt KontoI):</P>
<PRE CLASS="kode-western">import java.util.ArrayList;

public interface KontoI extends java.rmi.Remote
{
  public void overf&oslash;rsel(int kroner) throws java.rmi.RemoteException;
  public int saldo()                 throws java.rmi.RemoteException;
  public ArrayList bev&aelig;gelser()      throws java.rmi.RemoteException;
}</PRE><P CLASS="western">
Fjerninterfacet skal arve fra interfacet java.rmi.Remote og alle
metoder skal kunne kaste undtagelsen java.rmi.RemoteException. 
</P>
<H3 CLASS="western">19.2.1 <a name='afsn19.2.1'></a>P&aring; serversiden</H3>
<P CLASS="western">P&aring; serversiden skal vi implementere
Konto-interfacet og programmere den funktionalitet, der skjuler sig
bag det i et serverobjekt, der skal arve fra UnicastRemoteObject.
Klassenavnet ender normalt p&aring; Impl (for at vise, at det er
implementationen af fjerninterfacet).</P>
<PRE CLASS="kode-western">import java.util.ArrayList;
import java.rmi.server.UnicastRemoteObject;

public class KontoImpl <B>extends UnicastRemoteObject implements KontoI</B>
{
<B>  public int saldo;</B>
<B>  public ArrayList bev&aelig;gelser;</B>

  public KontoImpl() throws java.rmi.RemoteException 
  {
    // man starter med 100 kroner
    saldo = 100;
    bev&aelig;gelser = new ArrayList();
  }

  public void overf&oslash;rsel(int kroner)
  {
    saldo = saldo + kroner;
    String s = &quot;Overf&oslash;rsel p&aring; &quot;+kroner+&quot; kr. Ny saldo er &quot;+saldo+&quot; kr.&quot;;
    bev&aelig;gelser.add(s);
    System.out.println(s);
  }

  public int saldo()
  {
    System.out.println(&quot;Der sp&oslash;rges om saldoen. Den er &quot;+saldo+&quot; kr.&quot;);
    return saldo;
  }

  public ArrayList bev&aelig;gelser()
  {
    System.out.println(&quot;Der sp&oslash;rges p&aring; alle bev&aelig;gelser.&quot;);
    return bev&aelig;gelser;
  }
}</PRE>
<P CLASS="western">Nu skal vi oprette et serverobjekt og registrere
vores tjeneste under et navn i RMI:</P>
<PRE CLASS="kode-western">import java.rmi.Naming;
public class Kontoserver
{
  public static void main(String[] arg) throws Exception
  {
    KontoI <B>k = new KontoImpl()</B>;
<B>    Naming.rebind(&quot;rmi://localhost/kontotjeneste&quot;, k);</B>
    System.out.println(&quot;Kontotjeneste registreret.&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Kontotjeneste registreret.
...</PRE><P CLASS="western">
Programmet afslutter ikke, men venter p&aring;, at noget henvender
sig, for at bruge tjenesten.</P>
<P CLASS="western">For at registreringen kan foreg&aring;, skal der
k&oslash;re en RMI-navnetjeneste, der holder styr p&aring;, hvilke
tjenester, der udbydes under hvilke navne og formidler kontakten
til dem. Det er et lille program, der hedder rmiregistry. Det
skal kende definitionen af de klasser, der overf&oslash;res, s&aring;
man starter det ofte samme sted som selve RMI-tjenesten.</P>

<P CLASS="western" STYLE="">N&aring;r vi
skal k&oslash;re vores server, sker det i fire trin:</P>
<UL>
  <LI><P CLASS="western">alle kildetekster overs&aelig;ttes til
  bytekode:<BR>  <FONT FACE="Courier, monospace">javac *.java</FONT>
  (eller i et udviklingsv&aelig;rkt&oslash;j)</P>
  <LI><P CLASS="western">ud fra KontoImpl.class laves RMI-stub-klassen
  (KontoImpl_Stub.class):<BR>  <FONT FACE="Courier, monospace">rmic
  KontoImpl</FONT></P>
  <LI><P CLASS="western">rmiregistry startes i et separat vindue (fra
  samme mappe, som bytekoden ligger i):<BR>  <FONT FACE="Courier, monospace">rmiregistry</FONT></P>
  <LI><P CLASS="western">til sidst kan Kontoserver startes fra et
  separat vindue:<BR>  <FONT FACE="Courier, monospace">java Kontoserver</FONT>
  (eller i et udviklingsv&aelig;rkt&oslash;j)</P>
</UL>
<H3 CLASS="western">19.2.2 <a name='afsn19.2.2'></a>P&aring; klientsiden</H3>
<P CLASS="western">P&aring; klientsiden skal vi sl&aring;
serverobjektet op i RMI-tjenesten og derefter bruge det objekt, vi
f&aring;r retur, som om det var serverobjektet selv (i virkeligheden
er det RMI-stubben):</P>
<PRE CLASS="kode-western">import java.util.ArrayList;
import java.rmi.Naming;

public class Kontoklient
{
<BR>  public static void main(String[] arg)
  {
    try 
    {
<B>      KontoI k =(KontoI) Naming.lookup(&quot;rmi://localhost/kontotjeneste&quot;);</B>
      k.overf&oslash;rsel(100);
      k.overf&oslash;rsel(50);
      System.out.println( &quot;Saldo er: &quot;+ k.saldo() );
      k.overf&oslash;rsel(-200);
      k.overf&oslash;rsel(51);
      System.out.println( &quot;Saldo er: &quot;+ k.saldo() );
      ArrayList bev&aelig;gelser = k.bev&aelig;gelser();

      System.out.println( &quot;Bev&aelig;gelser er: &quot;+ bev&aelig;gelser );
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Saldo er: 250
Saldo er: 101
Bev&aelig;gelser er: [Overf&oslash;rsel p&aring; 100 kr. Ny saldo er 200 kr., Overf&oslash;rsel p&aring; 50 kr. Ny saldo er 250 kr., Overf&oslash;rsel p&aring; -200 kr. Ny saldo er 50 kr., Overf&oslash;rsel p&aring; 51 kr. Ny saldo er 101 kr.]</PRE><P CLASS="western">
Sammen med Kontoklient skal ligge fjerninterfacet KontoI og
KontoImpl_Stub.</P>
<P CLASS="western">Mens kontoklienten k&oslash;rer, kommer der
f&oslash;lgende uddata fra Kontoserver:</P>
<PRE CLASS="kode-western">Overf&oslash;rsel p&aring; 100 kr. Ny saldo er 200 kr.
Overf&oslash;rsel p&aring; 50 kr. Ny saldo er 250 kr.
Der sp&oslash;rges om saldoen. Den er 250 kr.
Overf&oslash;rsel p&aring; -200 kr. Ny saldo er 50 kr.
Overf&oslash;rsel p&aring; 51 kr. Ny saldo er 101 kr.
Der sp&oslash;rges om saldoen. Den er 101 kr.
Der sp&oslash;rges p&aring; alle bev&aelig;gelser.</PRE><P CLASS="western">
Herunder ses de enkelte klassers funktioner.</P>

<P CLASS="western"><IMG SRC="bog20_html_6f580c32.gif" NAME="Objekt2" ALIGN=MIDDLE>
</P>
<H2 CLASS="western">19.3 <a name='afsn19.3'></a>Opgaver</SPAN></H2>
<P CLASS="western">Pr&oslash;v eksemplet p&aring; RMI. Overs&aelig;t
.java-filerne og find ud af hvor .class-filerne ligger. Start tre
terminalvinduer (DOS-vinduer i Windows). I hvert vindue skal du
skrive</P>
<PRE CLASS="western">  cd &lt;stedet hvor .class-filerne ligger&gt;
</PRE><P CLASS="western">
Skriv derefter, i vindue 1:</P>
<PRE CLASS="western">  rmic KontoImpl
  rmiregistry
</PRE><P CLASS="western">
Skriv derefter, i vindue 2:</P>
<PRE CLASS="western">  java Kontoserver
</PRE><P CLASS="western">
Skriv derefter, i vindue 3:</P>
<PRE CLASS="western">  java Kontoklient</PRE><H3 CLASS="western">
19.3.1 <a name='afsn19.3.1'></a>Server og klient to forskellige steder</H3>
<P CLASS="western">N&aring;r ovenst&aring;ende fungerer, s&aring;
pr&oslash;v at k&oslash;re klienten i en anden mappe: Kopi&eacute;r
KontoI.class, Kontoklient.class og KontoImpl_Stub.class over i en
anden mappe og pr&oslash;v derfra.</P>
<P CLASS="western">Pr&oslash;v derefter at rette i Kontoklient, s&aring;dan
at klienten sl&aring;r op i rmiregistry p&aring; en anden maskine. Er
v&aelig;rtsmaskinens IP-nummer f.eks. 192.168.1.42, retter du i
Kontoklient til:</P>
<PRE CLASS="kode-western">    KontoI k =(KontoI) Naming.lookup(&quot;rmi://192.168.1.42/kontotjeneste&quot;);</PRE>

<H2 CLASS="western" STYLE="">19.4 <a name='afsn19.4'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel19.jsp#afsn19.4">
  <input type='checkbox' name='vis' value='19.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='19.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">19.4.1 <a name='afsn19.4.1'></a>RMI og pakker</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel19.jsp#afsn19.4.1">
  <input type='checkbox' name='vis' value='19.4.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='19.4.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel18.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel20.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
